from rest_framework import serializers
from .models import Task, TaskManager

class TaskSerializer(serializers.ModelSerializer):
    assignee_id = serializers.UUIDField(source="assignee.id", read_only=True)
    assignee_name = serializers.CharField(source="assignee.name", read_only=True)
    reporter_id = serializers.UUIDField(source="reporter.id", read_only=True)

    class Meta:
        model = Task
        fields = [
            "id",
            "title",
            "description",
            "status",
            "priority",
            "due_date",
            "assignee",
            "assignee_id",
            "assignee_name",
            "reporter",
            "reporter_id",
            "created_at",
        ]
        read_only_fields = ["id", "created_at"]


class TaskManagerSerializer(serializers.ModelSerializer):
    designed_by_name = serializers.CharField(source="designed_by.name", read_only=True)
    allotted_by_name = serializers.CharField(source="allotted_by.name", read_only=True)
    client_name_name = serializers.CharField(source="client_name.company", read_only=True)
    date = serializers.DateField(format="%d/%m/%Y", required=False, allow_null=True)
    allotted_date = serializers.DateField(format="%d/%m/%Y", required=False, allow_null=True)
    target_date = serializers.DateField(format="%d/%m/%Y", required=False, allow_null=True)
    completed_date = serializers.DateField(format="%d/%m/%Y", required=False, allow_null=True)

    class Meta:
        model = TaskManager
        fields = [
            "id",
            "client_name",
            "date",
            "client_name_name",
            "designed_by_name",
            "allotted_by_name",
            "job_order_no",
            "activities",
            "work_details",
            "division",
            "allotted_by",
            "allotted_date",
            "target_date",
            "designed_by",
            "designed_status",
            "completed_date",
            "client_status",
            "remarks",
            "billing",
            "created_at",
            "updated_at"
        ]
        read_only_fields = ["id", "created_at"]