from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework.views import APIView
from rest_framework.response import Response
from subscriptions.models import Profile, SalesPersons
from subscriptions.serializers import ProfileSerializers, SalesPersonsSerializers


class ProfileView(APIView):

    def get(self, request, pk=None):
        if pk:
            try:
                profile = Profile.objects.get(id=pk)
                serializer = ProfileSerializers(profile)
                return Response(serializer.data, status=200)
            except Profile.DoesNotExist:
                return Response({'error': 'Profile not found'}, status=404)

        profiles = Profile.objects.all()
        serializer = ProfileSerializers(profiles, many=True)
        return Response(serializer.data, status=200)

    def post(self, request, pk=None):
        if pk:
            try:
                profile = Profile.objects.get(id=pk)
                serializer = ProfileSerializers(profile, data=request.data)
            except Profile.DoesNotExist:
                return Response({'error': 'Profile not found'}, status=404)
        else:
            serializer = ProfileSerializers(data=request.data)

        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=200 if pk else 201)

        return Response(serializer.errors, status=400)

    def put(self, request, pk=None):
        if not pk:
            return Response({'error': 'Profile ID required'}, status=400)

        try:
            profile = Profile.objects.get(id=pk)
        except Profile.DoesNotExist:
            return Response({'error': 'Profile not found'}, status=404)

        serializer = ProfileSerializers(profile, data=request.data)

        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=200)

        return Response(serializer.errors, status=400)
class ProfileView(APIView):

    def get(self, request, pk=None):
        if pk:
            try:
                profile = Profile.objects.get(id=pk)
                serializer = ProfileSerializers(profile)
                return Response(serializer.data, status=200)
            except Profile.DoesNotExist:
                return Response({'error': 'Profile not found'}, status=404)

        profiles = Profile.objects.all()
        serializer = ProfileSerializers(profiles, many=True)
        return Response(serializer.data, status=200)

    def post(self, request, pk=None):
        if pk:
            try:
                profile = Profile.objects.get(id=pk)
                serializer = ProfileSerializers(profile, data=request.data)
            except Profile.DoesNotExist:
                return Response({'error': 'Profile not found'}, status=404)
        else:
            serializer = ProfileSerializers(data=request.data)

        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=200 if pk else 201)

        return Response(serializer.errors, status=400)

    def put(self, request, pk=None):
        if not pk:
            return Response({'error': 'Profile ID required'}, status=400)

        try:
            profile = Profile.objects.get(id=pk)
        except Profile.DoesNotExist:
            return Response({'error': 'Profile not found'}, status=404)

        serializer = ProfileSerializers(profile, data=request.data)

        if serializer.is_valid():
            serializer.save()
            return Response(serializer.data, status=200)

        return Response(serializer.errors, status=400)



class SalesPersonsView(APIView):
    def get(self, request):
        sales_persons = SalesPersons.objects.all()
        sales_persons_serializers = SalesPersonsSerializers(
            sales_persons, many=True)
        if sales_persons_serializers:
            return Response(sales_persons_serializers.data, status=200)
        return Response(sales_persons_serializers.errors, status=400)


class ExitstEmployeeList(APIView):
    def get(self, request):
        exitst_employee = Profile.objects.filter(is_exist_employee=True)
        exitst_employee_serializer = ProfileSerializers(
            exitst_employee, many=True)

        if exitst_employee_serializer:
            return Response(exitst_employee_serializer.data, status=200)

        return Response(exitst_employee_serializer.errors, status=400)
