from pyexpat import model
from rest_framework import serializers
from students.models import Student, Course, StudentPayment


class CourseSerializer(serializers.ModelSerializer):
    class Meta:
        model = Course
        fields = [
            "id", "course_name", "course_fee", "course_duration", "course_description"
        ]


class StudentSerializer(serializers.ModelSerializer):
    student_course_name = serializers.CharField(source='student_course.course_name', read_only=True)
    class Meta:
        model = Student
        fields = [
            "id", "student_name", "student_course", 'student_course_name', "email", "phone_number", "batch", "is_online"
        ]


class StudentPaymentSerializer(serializers.ModelSerializer):
    student_name =  serializers.CharField(source="student.student_name", read_only=True)
    class Meta:
        model = StudentPayment
        fields = [
            "id", "student", 'student_name', "payment_date", "amount", "payment_method", "description",
            # "student_pending_amount"
        ]
