import os
import sys

# Add the project directory to the Python path
sys.path.insert(0, os.path.dirname(__file__))

# Set your Django settings module
os.environ.setdefault("DJANGO_SETTINGS_MODULE", "marketizr.settings")

# More robust approach for cPanel
try:
    from django.core.wsgi import get_wsgi_application
    
    # Check if Django is already configured
    from django.conf import settings
    if not settings.configured:
        application = get_wsgi_application()
    else:
        # Django is already configured, just get the application
        from django.core.wsgi import WSGIHandler
        application = WSGIHandler()
        
except Exception as e:
    # Fallback: try to get application directly
    from django.core.wsgi import get_wsgi_application
    application = get_wsgi_application()