from django.contrib import admin
from office.models import DailyReport, OfficeExpense, CompanyCalendar, ContentCalendar, Activity

class DailyReportAdmin(admin.ModelAdmin):
    list_display = ('profiles', 'date', 'created_at')
    search_fields = ('profiles__user__username', 'date')
    list_filter = ('date', 'profiles')
    ordering = ('-created_at',)
    date_hierarchy = 'date'


class OfficeExpenseAdmin(admin.ModelAdmin):
    list_display = ('expense_type', 'amount', 'date', 'created_at')
    search_fields = ('expense_type',)
    list_filter = ('date', 'expense_type')
    ordering = ('-created_at',)
    date_hierarchy = 'date'


class ActivityAdmin(admin.ModelAdmin):
    list_display = ('title', 'status', 'assigned_to', 'created_by', 'due_date', 'created_at')
    search_fields = ('title', 'description')
    list_filter = ('status', 'assigned_to', 'created_by', 'due_date')
    ordering = ('-created_at',)
    date_hierarchy = 'created_at'


admin.site.register(DailyReport)
admin.site.register(OfficeExpense)
admin.site.register(CompanyCalendar)
admin.site.register(ContentCalendar)
admin.site.register(Activity, ActivityAdmin)