from rest_framework import serializers
from .models import ExpenceOfficeExpense, PaidThroughType
from .models.fund import SenderAccount, DepositAccount, FundTransfer

class OfficeExpenseSerializer(serializers.ModelSerializer):
    expence_account_name = serializers.SerializerMethodField()


    class Meta:
        model = ExpenceOfficeExpense
        fields = [
            'id',
            'date',
            'branch',
            'expence_account',
            'paid_through',
            'expence_account_name',
            'amount',
            'vendor',
            'reference_number',
            'receipts',
            'notes',
            'created_at',
            'updated_at'
        ]

    def get_expence_account_name(self, obj):
        return obj.expence_account.name if obj.expence_account else None


class PaidThroughSerializer(serializers.ModelSerializer):
    class Meta:
        model = PaidThroughType
        fields = [
            'id',
            'name',
            'created_at',
            'updated_at'
        ]


class SenderAccountSerializer(serializers.ModelSerializer):
    class Meta:
        model = SenderAccount
        fields = [
            'id',
            'name',
            'created_at',
            'updated_at'
        ]


class DepositAccountSerializer(serializers.ModelSerializer):
    class Meta:
        model = DepositAccount
        fields = [
            'id',
            'name',
            'created_at',
            'updated_at'
        ]


class FundTransferSerializer(serializers.ModelSerializer):
    class Meta:
        model = FundTransfer
        fields = [
            'id',
            'sender',
            'branch',
            'amount_received',
            'bank_charges',
            'payment_date',
            'payment_code',
            'payment_mode',
            'deposit_account',
            'reference_number',
            'payment_received_receipts',
            'notes',
            'created_at',
            'updated_at'
        ]