from django.db import models
import uuid
from enum import Enum
from lib.choices import choices_the_options

class Branch(Enum):
    HEAD_OFFICE = 'Head Office'
    KOZHIKODE = 'Kozhikode'
    KASARAGOD = 'Kasaragod'
    DUBAI = 'Dubai'
    QATAR = 'Qatar'


class ExpenseAccount(Enum):
    BANK = 'Bank'
    CASH = 'Cash'
    UPI = 'UPI'
    CREDIT_CARD = 'Credit Card'
    DEBIT_CARD = 'Debit Card'
    WALLET = 'Wallet'
    OTHER = 'Other'

class PaidThroughType(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    name = models.CharField(max_length=255)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return str(self.name)
    
    class Meta:
        ordering = ['-created_at']
        verbose_name_plural = 'Paid Through'


class ExpenceOfficeExpense(models.Model):
    date = models.DateField(null=True, blank=True)
    branch = models.CharField(max_length=255, choices=choices_the_options(Branch), default=Branch.HEAD_OFFICE.value)
    expence_account = models.ForeignKey(PaidThroughType, on_delete=models.SET_NULL, null=True, blank=True)
    paid_through = models.CharField(max_length=255, choices=choices_the_options(ExpenseAccount), default=ExpenseAccount.BANK.value)
    amount = models.DecimalField(max_digits=10, decimal_places=2)
    vendor = models.CharField(max_length=255, blank=True, null=True)
    reference_number = models.CharField(max_length=255, blank=True, null=True)
    receipts = models.FileField(upload_to='media/expences/', null=True, blank=True)
    notes = models.TextField(blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    # def __str__(self):
    #     # Return a string representation, e.g., the name of the expence_account if set, else a fallback
    #     if self.expence_account:
    #         return str(self.expence_account)
    #     return f"Expense on {self.date} - {self.amount}"
    
    class Meta:
        ordering = ['-created_at']