from rest_framework import viewsets, status, mixins
from rest_framework.decorators import action
from rest_framework.response import Response
from crm.models import CollectionData, Lead
from crm.serializers import (
    CollectionDataSerializer,
    LeadSerializer,
    ConvertCollectionToLeadSerializer
)

# class CollectionDataViewSet(
#     mixins.ListModelMixin,
#     mixins.CreateModelMixin,
#     mixins.RetrieveModelMixin,
#     mixins.UpdateModelMixin,
#     mixins.DestroyModelMixin,
#     viewsets.GenericViewSet
# ):
#     queryset = CollectionData.objects.all()
#     lookup_field = 'uuid'
#     serializer_class = CollectionDataSerializer
    
#     @action(detail=True, methods=['post'])
#     def convert_to_lead(self, request, pk=None):
#         collection = self.get_object()
#         serializer = ConvertCollectionToLeadSerializer(data=request.data)
#         serializer.is_valid(raise_exception=True)
        
#         lead = collection.convert_to_lead(
#             assigned_to=serializer.validated_data.get('assigned_to')
#         )
#         return Response(
#             LeadSerializer(lead).data,
#             status=status.HTTP_201_CREATED
#         )

class CollectionDataViewSet(
    mixins.ListModelMixin,
    mixins.CreateModelMixin,
    mixins.RetrieveModelMixin,
    mixins.UpdateModelMixin,
    mixins.DestroyModelMixin,
    viewsets.GenericViewSet,
):
    queryset = CollectionData.objects.all()
    # Remove these lines:
    # lookup_field = 'uuid'
    # lookup_url_kwarg = 'uuid'
    serializer_class = CollectionDataSerializer
    
    @action(detail=True, methods=['post'])
    def convert_to_lead(self, request, pk=None):  # Changed from uuid to pk
        collection = self.get_object()
        serializer = ConvertCollectionToLeadSerializer(data=request.data)
        serializer.is_valid(raise_exception=True)
        
        lead = collection.convert_to_lead(
            assigned_to=serializer.validated_data.get('assigned_to')
        )
        return Response(
            LeadSerializer(lead).data,
            status=status.HTTP_201_CREATED
        )

class CollectionAssignedPerson(mixins.ListModelMixin, viewsets.GenericViewSet):
    serializer_class = CollectionDataSerializer

    def get_queryset(self):
        profile_id = self.kwargs.get('uuid')
        # List all CollectionData assigned to this profile, ordered by latest first
        return CollectionData.objects.filter(
            assigned_to__profiles__id=profile_id
        ).select_related('assigned_to').order_by('-created_at')

# order code
# class CollectionAssignedPerson(mixins.ListModelMixin, viewsets.GenericViewSet):
#     serializer_class = CollectionDataSerializer

#     def get_queryset(self):
#         profile_id = self.kwargs.get('uuid')
#         # List all CollectionData assigned to this profile, ordered by latest first
#         return CollectionData.objects.filter(
#             assigned_to__profiles__id=profile_id
#         ).select_related('assigned_to').order_by('-created_at')



class CollectionByProfile(mixins.ListModelMixin, viewsets.GenericViewSet):
    serializer_class = CollectionDataSerializer

    def get_queryset(self):
        profile_id = self.kwargs.get('profile_id')
        return CollectionData.objects.filter(
            profiles__id=profile_id
        ).order_by('-created_at')

class LeadViewSet(
    mixins.ListModelMixin,
    mixins.CreateModelMixin,
    mixins.RetrieveModelMixin,
    mixins.UpdateModelMixin,
    mixins.DestroyModelMixin,
    viewsets.GenericViewSet
):
    queryset = Lead.objects.all()
    serializer_class = LeadSerializer
    
    @action(detail=True, methods=['post'])
    def convert_to_customer(self, request, pk=None):
        lead = self.get_object()
        if lead.convert_to_customer():
            return Response(
                {'status': 'Lead converted to customer'},
                status=status.HTTP_200_OK
            )
        return Response(
            {'error': 'Lead already converted'},
            status=status.HTTP_400_BAD_REQUEST
        )
    
class LeadConvertedPerson(mixins.ListModelMixin, viewsets.GenericViewSet):
    serializer_class = LeadSerializer

    def get_queryset(self):
        return Lead.objects.filter(is_converted=True).select_related('assigned_to').order_by('-created_at')