from rest_framework.views import APIView

from crm.models.collection import CollectionData
from crm.models.lead import Lead
import pickle as pk
from rest_framework import status
from rest_framework.response import Response

# Single Collection Data Delete Api 

class CollectionDataDeleteApi(APIView):
    def delete(self, request, pk):
        collection_data = CollectionData.objects.get(id=pk)
        collection_data.delete()
        return Response({'message': 'Collection Data Deleted Successfully'}, status=status.HTTP_200_OK)

class LeadDeleteview(APIView):
    def delete(self, request, pk):
        lead = Lead.objects.get(id=pk)
        lead.delete()
        return Response({'message': 'Lead Deleted Successfully'}, status=status.HTTP_200_OK)