from rest_framework.views import APIView
from rest_framework.response import Response
from crm.models.campaigns import Campaign
from crm.serializers.campaigns import CampaignSerializer


class CampaignView(APIView):
    def post(self, request):
        campaigns = CampaignSerializer(data=request.data)
        if campaigns.is_valid():
            campaigns.save()
            return Response(campaigns.data, status=200)
        return Response(campaigns.errors, status=401)
    
    def get(self, request):
        data = Campaign.objects.all()
        campaigns = CampaignSerializer(data, many=True)
        if campaigns:
            return Response(campaigns.data, status=201)
        return Response(status=401)
    

class CampaignPersonView(APIView):
    def get(self, pk):
        data = Campaign.objects.get(id=pk)
        campaigns = CampaignSerializer(data, many=True)
        if campaigns:
            return Response(campaigns.data, status=201)
        return Response(status=401)
