from rest_framework.views import APIView
from rest_framework.response import Response
from crm.models import Lead, Invoice, Quote
from rest_framework import status

from crm.serializers.lead import LeadSerializer

class ActivateCustomerView(APIView):
    def get(self, request):
        activated_leads = []
        activate_user = Quote.objects.filter(is_invoice_converted=True)
        for invoice in activate_user:
            lead = Lead.objects.get(id=invoice.lead.id)
            activated_leads.append(lead)
        print(activated_leads, "activated_leads")
        serializer = LeadSerializer(activated_leads, many=True)
        return Response({"message": "Customer(s) activated successfully", "leads": serializer.data}, status=status.HTTP_200_OK)
