from django.db import models
from enum import Enum
from lib.choices import choices_the_options
import uuid
from crm.models.collection import CollectionPlace
from subscriptions.models import Profile

class CampaignStatus(Enum):
    PLANNED = 'planned'
    ACTIVE = 'active'
    COMPLETED = 'completed'
    CANCELLED = 'cancelled'

class CampaignType(Enum):
    EMAIL = 'email'
    SMS = 'sms'
    OFFLINE = 'offline'
    SOCIAL_MEDIA = 'social_media'

class Campaign(models.Model):
    id = models.UUIDField(primary_key=True, default=uuid.uuid4, editable=False)
    name = models.CharField(max_length=255)
    description = models.TextField(blank=True, null=True)
    campaign_type = models.CharField(
        max_length=30,
        choices=choices_the_options(CampaignType),
        default=CampaignType.OFFLINE.value
    )
    location = models.CharField(max_length=55, choices=choices_the_options(CollectionPlace), default=CollectionPlace.KASARAGOD.value)
    start_date = models.DateField()
    end_date = models.DateField()
    budget = models.DecimalField(max_digits=12, decimal_places=2, blank=True, null=True)
    expected_revenue = models.DecimalField(max_digits=12, decimal_places=2, blank=True, null=True)
    created_by = models.ForeignKey(
        Profile,
        on_delete=models.PROTECT,
        related_name='campaigns_created'
    )
    status = models.CharField(
        max_length=20,
        choices=choices_the_options(CampaignStatus),
        default=CampaignStatus.PLANNED.value
    )
    created_at = models.DateTimeField(auto_now_add=True)
    updated_at = models.DateTimeField(auto_now=True)

    def __str__(self):
        return self.name
    
    class Meta:
        ordering = ['-created_at']
