from django.urls import path
from course.views_exam import (
    QuestionListCreateView, QuestionDetailView,
    start_exam, submit_exam, leaderboard, search_certificate, download_certificate
)

urlpatterns = [
    # Question management (Trainers only)
    path('courses/<uuid:course_id>/questions/', QuestionListCreateView.as_view(), name='question-list-create'),
    path('questions/<uuid:pk>/', QuestionDetailView.as_view(), name='question-detail'),
    
    # Exam functionality
    path('courses/<uuid:course_id>/exam/start/', start_exam, name='start-exam'),
    path('exams/<uuid:exam_id>/submit/', submit_exam, name='submit-exam'),
    
    # Leaderboard
    path('leaderboard/', leaderboard, name='leaderboard'),
    path('courses/<uuid:course_id>/leaderboard/', leaderboard, name='course-leaderboard'),
    
    # Certificate search
    path('certificates/search/', search_certificate, name='search-certificate'),
    path('certificates/<uuid:certificate_id>/download/', download_certificate, name='download-certificate'),
]